<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Include all the needed files
 *
 * (!) Note for Clients: please, do not modify this or other theme's files. Use child theme instead!
 */

if ( ! defined( 'US_ACTIVATION_THEMENAME' ) ) {
	define( 'US_ACTIVATION_THEMENAME', 'Impreza' );
}

$us_theme_supports = array(
	'plugins' => array(
		'js_composer' => '/framework/plugins-support/js_composer/js_composer.php',
		'Ultimate_VC_Addons' => '/framework/plugins-support/Ultimate_VC_Addons.php',
		'revslider' => '/framework/plugins-support/revslider.php',
		'contact-form-7' => NULL,
		'codelights' => '/framework/plugins-support/codelights.php',
		),
);

require dirname( __FILE__ ) . '/framework/framework.php';

unset( $us_theme_supports );
function custom_excerpt_length( $length ) {        return 10;    }    add_filter( 'excerpt_length', 'custom_excerpt_length', 250 );
add_filter('use_block_editor_for_post', '__return_false', 10);

//Exclude pages from WordPress Search
if (!is_admin()) {
function wpb_search_filter($query) {
if ($query->is_search) {
$query->set('post_type', 'post');
}
return $query;
}
add_filter('pre_get_posts','wpb_search_filter');
}


add_filter("wpcf7_validate", 'custom_checkbox_validation', 10, 2 ); 

function custom_checkbox_validation($result, $tags){    
    $checked = 0;
    foreach ( $tags as $tag ) {
		$type = $tag->type;
		$name = $tag->name; 
		$value = isset( $_POST[$name] ) ? (array) $_POST[$name] : array(); 
		if($type == "checkbox" && !empty( $value )){
		    $checked = 1;
		}
		if($checked == 0 && $name == "checkbox-495"){
            $result->invalidate( $tag, 'Please select atleast one service' ); 
        }
    }
    

    return $result;

}

function typed_init() {
    echo '<script>
	 jQuery(document).ready(function($){
  $(".disablepaste").bind("paste",function(e) {
      e.preventDefault();
  });
});</script>';
}
add_action('wp_footer', 'typed_init');

add_filter( 'xmlrpc_enabled', '__return_false' );

// deactivate new block editor
function phi_theme_support() {
    remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'phi_theme_support' );