<?php

class mo2f_scanner_parts
{
	function __construct(){
	}


	function check_scan_status(){

		global $wpdb;
		if(is_multisite()){
			$query="SELECT `meta_value` from `".$wpdb->base_prefix."sitemeta`  WHERE `meta_key` = 'mo_stop_scan'";
			$stop_scan= $wpdb->get_results($query);
			$stop_scan_process=$stop_scan[0]->meta_value;
		}else{
			$query="SELECT `option_value` from `".$wpdb->base_prefix."options`  WHERE `option_name` = 'mo_stop_scan'";
			$stop_scan= $wpdb->get_results($query);
			$stop_scan_process=$stop_scan[0]->option_value;
		}
		
		if($stop_scan_process=="1") {
			$this->mo2f_end_scan();
			return "1";
		}
		else{
			return "0";
		}
	}
    function file_cron_scan(){//main cron function

	    $scan_request = isset($_GET['scan_request'])? $_GET['scan_request']:false;
	    if($scan_request) {
	    	$status=$this->check_scan_status();

	    	if($status){
	    		exit;
				//abort
		    }
		    ini_set('memory_limit', '-1');
			ini_set('max_execution_time', 0);
		    $scan_mode           = isset( $_GET['scan_mode'] ) ? $_GET['scan_mode'] : false;
		    $scan_stage_complete = isset( $_GET['scan_stage_complete'] ) ? $_GET['scan_stage_complete'] : false;
		    $reportid            = isset( $_GET['reportid'] ) ? $_GET['reportid'] : false;

		    $scanverification      = isset( $_GET['scanverification'] ) ? $_GET['scanverification'] : false;
		    $scanverification_code = get_site_option( "mo2f_scanverification" );
		    if ( $scanverification != $scanverification_code ) {
			    error_log( "Request Does not exists" );
			    exit;
		    }

		    $mo2f_malware_db_handler = new MoWpnsDB();
		    $mo_wpns_scan_handler    = new Mo_wpns_Scan_Handler_Cron();

		    //switch case stage wise
		    if ( $scan_mode == 'Quick Scan' ) {
			    $scan_config = MoWpnsConstants::$quick_scan_configuration;
		    } elseif ( $scan_mode == 'Standard Scan' ) {
			    $scan_config = MoWpnsConstants::$standard_scan_configuration;
		    } else {
			    $scan_config = get_site_option( 'mo2f_custom_scan_config' ); 
		    }

		    $repo_status_code = get_site_option('mo2f_repo_status');
		    if ( ($scan_config['check_repo'] == 0 || $repo_status_code < 0) && $scan_stage_complete == 3 ) {//repo check not required so scan ended

			    $decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
			    $mo_wpns_files_scanned=$decoded_scan_status->total_files;
			    $decoded_scan_status->files_scanned=$mo_wpns_files_scanned;
			    $encoded_scan_status=json_encode($decoded_scan_status);
			    update_site_option('mo_wpns_scan_status', $encoded_scan_status);
			    $this->mo2f_end_scan();
			    exit;
		    }

		    $uploads_dir = wp_upload_dir();
			$uploads_path= $uploads_dir['basedir'];
		    $repo_file_path = $uploads_path . DIRECTORY_SEPARATOR . "miniorangescan";
		    $current_time   = time();
		    $time_limit     = ini_get( 'max_execution_time' );
		    usleep(10000);//10miliseconds
		    switch ( $scan_stage_complete ) {
			    case 1:
				    $this->mo2f_scan_with_service( $scan_config, $reportid, $scanverification);
				    break;
			    case 2:
				    $this->mo2f_check_ext_link( $scan_config,$reportid,$scanverification);
				    break;
				case 3:
				    $mo_wpns_scan_handler->mo2f_download_plugins_wp( $repo_file_path, $scan_config, $current_time, $time_limit,$reportid, $scanverification);
				    break;
			    case 4:
				    $mo_wpns_scan_handler->mo2f_download_themes_wp( $repo_file_path, $scan_config, $current_time, $time_limit,$reportid, $scanverification);
				    break;
			    case 5:
				    $mo_wpns_scan_handler->mo2f_download_core_wp( $repo_file_path, $scan_config,$reportid, $scanverification);
				    break;
			    case 6:
				    $this->mo2f_check_with_repo( $scan_config, $repo_file_path,$reportid,$scanverification);
				    break;
			    case 7:
				    $this->mo2f_end_scan();
				    break;
		    }
	    }
    }

    function mo2f_scan_with_service($scan_config, $reportid, $scanverification){
	    $current_time= time();
    	$mo2f_malware_db_handler = new MoWpnsDB();
    	$files_to_scan=$mo2f_malware_db_handler->get_files_in_parts();
    	$mo_wpns_scan_handler = new Mo_wpns_Scan_Handler_Cron();

    	if(empty($files_to_scan)){
			
			$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
			$scan_malware_count=$last_report[0]->malware_count;
			$last_scan=$mo2f_malware_db_handler->count_files_last_scan($reportid);

			$hostname = 'scanner.api.xecurify.com';
			$malware_server_status = $mo_wpns_scan_handler->mo_wpns_check_malware_server_status($hostname);
			if($malware_server_status){
				$host = 'http://scanner.api.xecurify.com/malwareservice/rest/file/data';
				$postdata = http_build_query(array('fileCount' => $last_scan, 'maliciousCount' => $scan_malware_count));
				$content_type = 'application/x-www-form-urlencoded';
		        $lastRequest = $mo_wpns_scan_handler->mo_wpns_malware_scan_request($host, $content_type,$postdata);
		    }
		    $Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		    $response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 2);

    	}else{//sending next 100 files
	    	$current_time= time();
	    	$time_limit= ini_get('max_execution_time');
	    	$result=$mo_wpns_scan_handler->get_scan_result_parts($scan_config, $current_time, $time_limit,$mo2f_malware_db_handler, $files_to_scan);

	    	if($result['scan']){
				foreach ($result['scan'] as $key => $value) {
					$value=array('scan'=>'Premium');
					$mo2f_malware_db_handler->add_report_details($reportid, $key, $value);
				}
			}
			$mo2f_malware_db_handler->update_files_scan($files_to_scan, $result['file_count']);

			$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
			$result['file_count']= $last_report[0]->scanned_files + $result['file_count'];
			$result['malware_count'] = $last_report[0]->malware_count + $result['malware_count'];
			$result['malicious_link'] = 0;
			$result['repo_issues'] = $last_report[0]->repo_issues;

			$mo2f_malware_db_handler->scan_report_complete($reportid, $result['file_count'], $result['malware_count'], $result['repo_issues'], $result['malicious_link']);

		    $Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		    $response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 1);

	    }
    }

    function mo2f_check_ext_link($scan_config, $reportid, $scanverification){
    	$mo2f_malware_db_handler = new MoWpnsDB();
    	$files_to_scan=$mo2f_malware_db_handler->get_files_for_link();
	    $currentFileScanTime=time();

    	if(!empty($files_to_scan) && $scan_config['ext_link_check']){
	    	$mo_wpns_scan_handler = new Mo_wpns_Scan_Handler_Cron();
	    	$current_time= time();
	    	$time_limit= ini_get('max_execution_time');
	    	$response=$mo_wpns_scan_handler->scan_for_ext_link($files_to_scan, $scan_config, $current_time, $time_limit, $reportid);
	    	
	    	if($response['scan']){
				foreach ($response['scan'] as $key => $value) {
					$mo2f_malware_db_handler->add_report_details($reportid, $key, $value);
				}
			}
			$mo2f_malware_db_handler->update_files_scan_ext_link($files_to_scan, $response['file_count']);

			$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
			$response['file_count']= $last_report[0]->scanned_files;
			$response['malware_count'] = $last_report[0]->malware_count;
			$response['repo_issues'] = $last_report[0]->repo_issues;
			$response['malicious_link'] = $last_report[0]->malicious_links + $response['malicious_link'];

			$mo2f_malware_db_handler->scan_report_complete($reportid, $response['file_count'], $response['malware_count'], $response['repo_issues'], $response['malicious_link']);

		    $response=$mo_wpns_scan_handler->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 2);
		}else{
		    $decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
		    $mo_wpns_files_scanned=$decoded_scan_status->total_files;
		    $decoded_scan_status->files_scanned=0.85*$mo_wpns_files_scanned;
		    $encoded_scan_status=json_encode($decoded_scan_status);
		    update_site_option('mo_wpns_scan_status', $encoded_scan_status);
		    $Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		    $response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 3);
			
		}
    }

    function mo2f_check_with_repo($scan_config, $repo_file_path,$reportid, $scanverification){
	    $download_status=false;
	    $decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
	    $decoded_scan_configuration->status_download_time=$download_status;
	    $encoded_scan_configuration=json_encode($decoded_scan_configuration);
	    update_site_option("mo_wpns_scan_status",$encoded_scan_configuration);
    	$mo2f_malware_db_handler = new MoWpnsDB();
    	$response=array();
    	$repo_status = get_site_option('mo2f_repo_status');
    	$repo_key = get_site_option('mo2f_current_repo_key');
    	if($repo_status != 0){
    		$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
    		if($repo_status == -95){
    			if(!empty($last_report)){
    				$mo2f_malware_db_handler->mo2f_update_net_issue($reportid);
    			}
    			$this->mo2f_end_scan();
    			exit;
    		}else{
	    		if(! empty($last_report)){
	    			$issue = $last_report[0]->repo_key;
	    			if($repo_key == 'core'){
	    				$issue.= "WordPress Core Files;";
	    			}else{
	    				$issue.= $repo_key.";";
	    			}
		    		$mo2f_malware_db_handler->mo2f_update_repo_issue($reportid, $issue);
	    		}
	    		
	    		$this->mo2f_make_next_request($scan_config, $reportid, $scanverification, $repo_file_path);
    		}
    		
    	}else{
    		$files_to_scan=$mo2f_malware_db_handler->get_files_for_repo($repo_key);
    		if(empty($files_to_scan)){
    			$this->mo2f_make_next_request($scan_config, $reportid, $scanverification, $repo_file_path);
    		}else{
	    		$mo_wpns_scan_handler = new Mo_wpns_Scan_Handler_Cron();
		    	$current_time= time();
		    	$time_limit= ini_get('max_execution_time');
		    	$response=$mo_wpns_scan_handler->scan_with_repo($files_to_scan, $scan_config, $current_time, $time_limit, $reportid, $repo_file_path);
		    	
		    	if($response['scan']){
					foreach ($response['scan'] as $key => $value) {
						$mo2f_malware_db_handler->add_report_details($reportid, $key, $value);
					}
				}
				$mo2f_malware_db_handler->update_files_scan_repo($files_to_scan, $response['file_count']);

				$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
				$response['file_count']= $last_report[0]->scanned_files;
				$response['malware_count'] = $last_report[0]->malware_count;
				$response['repo_issues'] = $last_report[0]->repo_issues + $response['repo_issues'];
				$response['malicious_link'] = $last_report[0]->malicious_links;

				$mo2f_malware_db_handler->scan_report_complete($reportid, $response['file_count'], $response['malware_count'], $response['repo_issues'], $response['malicious_link']);
				$Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
		    	$response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, 6);
			}
    	}
    }

    function mo2f_end_scan(){
    	$mo_wpns_scan_handler = new Mo_wpns_Scan_Handler_Cron();
    	$mo2f_malware_db_handler = new MoWpnsDB();
		$uploads_dir = wp_upload_dir();
		$uploads_path= $uploads_dir['basedir'];
	    $repo_file_path = $uploads_path . DIRECTORY_SEPARATOR . "miniorangescan";
		if(is_dir($repo_file_path)){
			$mo_wpns_scan_handler->remove_dir($repo_file_path);
		}
	    $decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
	    $decoded_scan_configuration->scan_progress="COMPLETE";
	    $encoded_scan_configuration=json_encode($decoded_scan_configuration);
		update_site_option("mo_wpns_scan_status",$encoded_scan_configuration);
		$mo2f_malware_db_handler->delete_files_parts();
		exit;
    }

    function mo2f_make_next_request($scan_config, $reportid, $scanverification, $repo_file_path){
    	$download_info = get_site_option('mo2f_download_info');
    	$download_done = get_site_option('mo2f_download_done');
    	$Mo_wpns_Scan_Handler_Cron = new Mo_wpns_Scan_Handler_Cron();
    	if(is_dir($repo_file_path)){
			$Mo_wpns_Scan_Handler_Cron->remove_dir($repo_file_path);
		}
    	if($download_info['stage'] == 'plugins'){
    		if($download_done < $download_info['plugin_count']){
    			$next_stage = 3;
    		}else{
    			update_site_option('mo2f_download_done',0);
    			$next_stage = 4;
    		}
    	}else if ($download_info['stage'] == 'themes') {
    		if($download_done < $download_info['theme_count']){
    			$next_stage = 4;
    		}else{
    			update_site_option('mo2f_download_done',0);
    			$next_stage = 5;
    		}
    	}else{
    		$next_stage = 7;
    	}
    	
    	$response=$Mo_wpns_Scan_Handler_Cron->mo2f_wp_remote_get($scan_config['type_scan'], $reportid, $scanverification, $next_stage);
    }

}new mo2f_scanner_parts;
