<?php

class Mo_wpns_Scan_Handler{
	private $total_files_to_scan;
	public $scanned_files = array();
	function __construct(){

	}
	function mo2f_scan_all_files($scan_config){
		update_option('mo_wpns_scan_initialize', 0);
		update_option('mo_wpns_malware_scan_in_progress','IN PROGRESS');
		update_option('mo_wpns_files_scanned',0);
		update_option('mo_wpns_infected_files',0);
		ini_set('memory_limit', '-1');
		ini_set('max_execution_time', 0);
		$result = array();
		$folderpaths = array();
		$wp_repo_file = array();
		$folderNames = "";
		$repo_check_status = $scan_config['check_repo'];
		$repo_check_status_code = 0;
		$base = dirname(dirname(dirname(dirname(plugin_dir_path(__FILE__)))));
		$hostname = 'wordpress.org';
		$wordpress_server_status = $this->mo_wpns_check_malware_server_status($hostname);
		if (!is_writable($base.DIRECTORY_SEPARATOR."wp-content".DIRECTORY_SEPARATOR."uploads")) {
			$scan_config['check_repo'] = 0;
			$repo_check_status_code = -97;
		}
		if (!$wordpress_server_status) {
			$scan_config['check_repo'] = 0;
			$repo_check_status_code = -98;
		}
		$repo_file_path=$base.DIRECTORY_SEPARATOR."wp-content".DIRECTORY_SEPARATOR."uploads".DIRECTORY_SEPARATOR."miniorangescan";
		if($scan_config['core_scan'] == 1){
			$folderpaths['base'] = $base;
			$folderNames .= "WP Files;";
		} 		
		if($scan_config['plugin_scan'] == 1){
			$folderpaths['plugins'] = $base.DIRECTORY_SEPARATOR."wp-content".DIRECTORY_SEPARATOR."plugins";
			$folderNames .= "Plugins;";
		}
		if($scan_config['theme_scan'] == 1){
			$folderpaths['themes'] = $base.DIRECTORY_SEPARATOR."wp-content".DIRECTORY_SEPARATOR."themes";
			$folderNames .= "Themes;";
		}
		if($scan_config['check_repo'] == 1){
			$folderNames .= "WP Repo Files;";
		}
		$this->count_total_files($folderpaths, $base, $scan_config);

		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}
		if ( ! function_exists( 'plugins_api' ) ) {
		    require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
		}
		if($scan_config['check_repo'] == 1){
			if(!is_dir($repo_file_path)){
				mkdir($repo_file_path);
			}
			if($scan_config['core_scan'] == 1){
	            require(ABSPATH . 'wp-includes/version.php');
				//wordpress name to be changed to be changed based on version
				$zip_name="wp-".$wp_version;
				$wp_repo_file['base']=$repo_file_path.DIRECTORY_SEPARATOR.$zip_name;
				update_option('downloaded_wordpress_repo_name', $zip_name);
				if(!is_dir($repo_file_path.DIRECTORY_SEPARATOR.$zip_name)){
					$result = $this->download_repo($zip_name, $wp_version, $repo_file_path);
					if($result === -99){
						$scan_config['check_repo'] = 0;
						$repo_check_status_code = -99;
					}else if(!$result){
						$scan_config['check_repo'] = 0;
						$repo_check_status_code = -100;
					}
				}
			}
			if($scan_config['plugin_scan'] == 1 && $scan_config['check_repo']){
				$wp_plugin_repo_file=$repo_file_path.DIRECTORY_SEPARATOR."plugins";
				if(!is_dir($wp_plugin_repo_file)){
					mkdir($wp_plugin_repo_file);
				}
				$wp_repo_file['plugins']=$wp_plugin_repo_file;
				$plugin_list=get_site_transient( 'update_plugins' );
		        $all_plugins=array();
				foreach ($plugin_list as $key => $value) {
					if($key=='response'||$key=='no_update'){
						foreach ($value as $ke => $val) {
							$all_plugins[$ke] = $val;
						}
					}
				}
		        $result = $this->iterator_plugins_themes($all_plugins, $wp_plugin_repo_file, 'plugins');
		        if($result === -99){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -99;
				}else if(!$result){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -100;
				}
			}
			if($scan_config['theme_scan'] == 1 && $scan_config['check_repo']){
				$wp_theme_repo_file=$repo_file_path.DIRECTORY_SEPARATOR."themes";
				if(!is_dir($wp_theme_repo_file)){
					mkdir($wp_theme_repo_file);
				}
				$wp_repo_file['themes']=$wp_theme_repo_file;
				$all_themes=get_site_transient( 'update_themes' )->checked;
		        $result = $this->iterator_plugins_themes($all_themes, $wp_theme_repo_file, 'themes');
		        if($result === -99){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -99;
				}else if(!$result){
					$scan_config['check_repo'] = 0;
					$repo_check_status_code = -100;
				}
			}
		}
		$mo2f_malware_db_handler = new MoWpnsDB();
		$time = current_time('timestamp');
		$result = $this->get_scan_result($mo2f_malware_db_handler, $folderpaths, $wp_repo_file, $scan_config, $base);
		$reportid = $mo2f_malware_db_handler->create_scan_report($folderNames, $scan_config['type_scan'], $time);
		if($result['scan']){
			foreach ($result['scan'] as $key => $value) {
				$mo2f_malware_db_handler->add_report_details($reportid, $key, $value);
			}
		}
		$result['repo_issues'] = $repo_check_status!=$scan_config['check_repo'] ? $repo_check_status_code : $result['repo_issues'];
		$mo2f_malware_db_handler->scan_report_complete($reportid, $result['file_count'], $result['malware_count'], $result['repo_issues'], $result['malicious_link']);
		if(is_dir($repo_file_path)){
			$this->remove_dir($repo_file_path);
		}
		update_option('mo_wpns_malware_scan_in_progress','COMPLETE');
		$total_scan=$mo2f_malware_db_handler->count_files();
		$total_malicious=$mo2f_malware_db_handler->count_malicious_files();
		$last_scan=$mo2f_malware_db_handler->count_files_last_scan($reportid);
		$malicious_last_scan=$mo2f_malware_db_handler->count_malicious_last_scan($reportid);
		if($total_scan > 999){
			$total_scan=($total_scan/1000);
			$total_scan= round($total_scan,1)."k";
		}
		if($total_malicious > 999){
			$total_malicious=($total_malicious/1000);
			$total_malicious= round($total_malicious,1)."k";
		}
		$response=array('total_files'=>$total_scan, 'total_mal'=>$total_malicious, 'scan_files'=>$last_scan, 'mal_files'=>$malicious_last_scan);
		wp_send_json($response);
	}

	function iterator_plugins_themes($themes_or_plugins, $path, $type=''){
        foreach($themes_or_plugins as $key => $data){
        	if($type=='plugins'){
	            $plugin_slug=$data->slug;
	            $plugin_directory_location=dirname(dirname(dirname($path))).DIRECTORY_SEPARATOR.'plugins';
	            $plugin_data=get_plugin_data($plugin_directory_location.DIRECTORY_SEPARATOR.$data->plugin);
	            $plugin_version=$plugin_data['Version'];
	            if(!is_dir($path.DIRECTORY_SEPARATOR.$plugin_slug)){
	            	$result= $this->download_repo($plugin_slug, $plugin_version, $path, $type);
	            	if($result === -99){
						return -99;
					}else if(!$result){
	            		return false;
	            	}
	            }
	        } else if($type=='themes'){
	        	if(!is_dir($path.DIRECTORY_SEPARATOR.$key)){
	        		$result= $this->download_repo($key, $data, $path, $type);
	        		if($result === -99){
						return -99;
					}else if(!$result){
	            		return false;
	            	}
	        	}
	        }
        }
        return true;
    }

    function download_repo($zip_name, $version, $path, $type=''){
		if ($type=='plugins') {
			$download_link="https://downloads.wordpress.org/plugin/".$zip_name.".".$version.".zip";
	        $plugin_name=$zip_name.'.'.$version;
	        $download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", file_get_contents($download_link));
	        if( $download_result){
	            $result = $this->unzip_downloaded_repo($zip_name, $path);
	            return $result;
	        }else {
	        	$download_link="https://downloads.wordpress.org/plugin/".$zip_name.".zip";
	        	$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", file_get_contents($download_link));
	        	if( $download_result){
		            $result = $this->unzip_downloaded_repo($zip_name, $path);
		            return $result;
		        }else {
		            error_log("Unable to download Plugin: ".$plugin_name);
		            return -99;
		        }
		        return -99;
	        }
		} else if($type=='themes'){
			$theme_name=$zip_name.'.'.$version;
			$download_link="https://downloads.wordpress.org/theme/".$theme_name.".zip";
	        $download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", file_get_contents($download_link));
	        if( $download_result){
	            $result = $this->unzip_downloaded_repo($zip_name, $path);
	            return $result;
	        }else {
	        	$download_link="https://downloads.wordpress.org/theme/".$zip_name.".zip";
	        	$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.".zip", file_get_contents($download_link));
	        	if( $download_result){
		            $result = $this->unzip_downloaded_repo($zip_name, $path);
		            return $result;
		        }else {
		            error_log("Unable to download Theme: ".$theme_name);
		            return -99;
		        }
		        return -99;
	        }
		} else {
			$download_link="https://wordpress.org/wordpress-".$version.".zip";
			$download_result=@file_put_contents($path.DIRECTORY_SEPARATOR.$zip_name.'.zip', file_get_contents($download_link));
			if($download_result){
				$result=$this->unzip_downloaded_repo($zip_name, $path);
				return $result;
			} else {
				error_log("Unable to download wordpress-".$version);
				return -99;
			}
		}
		return false;
	}

	function unzip_downloaded_repo($name, $path){
		$zip = new ZipArchive;
        $folder_path=$path.DIRECTORY_SEPARATOR.$name.".zip";
        $res = $zip->open($folder_path);
        if ($res === TRUE) {
            // extract it to the path we determined above
            $result = $zip->extractTo($path);
            $zip->close();
            if ($name == get_option('downloaded_wordpress_repo_name')) {
            	rename($path.DIRECTORY_SEPARATOR."wordpress", $path.DIRECTORY_SEPARATOR.$name);
            }
            unlink($folder_path);
            return true;
        } else {
            return false;
        }
	}

	function get_scan_result($mo2f_malware_db_handler=null, $folderpaths=array(), $repo_folder_path=array(), $scan_config, $base){
		if(!empty($folderpaths)){
			if ( in_array( 'curl', get_loaded_extensions() ) ) {
				$scanresults=array();
				$nooffiles=0;
				$scan_malware_count = 0;
				$repo_issue_count = 0;
				$malicious_link_count = 0;
				$file_ext = $scan_config['file_extension'];
				$host = 'http://scanner.api.xecurify.com/malwareservice/rest/file/upload';
				$extensions = array();
				$hostname = 'scanner.api.xecurify.com';
				$malware_server_status = $this->mo_wpns_check_malware_server_status($hostname);
				if(empty($file_ext)){
				}else{
					if(strpos($file_ext,';') !=false){
						$extensions = explode(";", $file_ext);
					}else{
						array_push($extensions, $file_ext);
					}
				}
				$folder_skip_array= empty($scan_config['path_skip']) ? array() : explode(";", $scan_config['path_skip']);
				$skip_path_array= array();
				for($i=0; $i<count($folder_skip_array); $i++){
					$pathParts = explode('/', rtrim(str_replace('\\', '/', $folder_skip_array[$i])));
					$n= sizeof($pathParts)-1;
					$folder= $pathParts[$n];
					array_push($skip_path_array, $folder);
				}
				$enable_extns = $scan_config['type_scan'] == "Custom Scan" && !empty($file_ext) ? false : true;
				foreach ($folderpaths as $value) {
					$onearr = array();
					if (is_dir($value)) {
						foreach ($iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($value, \RecursiveDirectoryIterator::SKIP_DOTS), \RecursiveIteratorIterator::SELF_FIRST) as $item) {
							if ($item->isFile()) {
								$scanresult=array();
								$source_file_path = $value . DIRECTORY_SEPARATOR . $iterator->getSubPathName();
								if ($value == $base && ($scan_config['core_scan'] == 1)){
									$arr = explode(DIRECTORY_SEPARATOR, $iterator->getSubPathName());
									if(($arr[count($arr)-1]== 'index.php' && (count($arr)==1 || in_array($arr[count($arr)-2], array('wp-content', 'plugins', 'themes'))) && !in_array('miniorangescan', $arr)) || (!in_array('plugins', $arr) && !in_array('themes', $arr) && !in_array('miniorangescan', $arr))){
										
									}else{
										continue;
									}
								}elseif ($value == $base.DIRECTORY_SEPARATOR.'wp-content'.DIRECTORY_SEPARATOR.'plugins' && explode(DIRECTORY_SEPARATOR,$iterator->getSubPathName())[0]=='index.php'){
									continue;
								} elseif ($value == $base.DIRECTORY_SEPARATOR.'wp-content'.DIRECTORY_SEPARATOR.'themes' &&  explode(DIRECTORY_SEPARATOR,$iterator->getSubPathName())[0]=='index.php'){
									continue;
								}
								$flag_skip=0;
								if($scan_config['type_scan'] == "Custom Scan" && !empty($folder_skip_array)){
									for($q=0; $q<count($skip_path_array); $q++){
										if(strpos($source_file_path, $skip_path_array[$q])){
											$flag_skip=1;
											break;
										}
									}
								}
								if($flag_skip == 1){
									continue;
								}
								$ext = pathinfo($source_file_path, PATHINFO_EXTENSION);
								$extns = $enable_extns ? true : (in_array($ext, $extensions) ? true : false);
								if($extns){
									$nooffiles++;
									if($nooffiles - get_option('mo_wpns_files_scanned') > 50){
										update_option('mo_wpns_files_scanned', $nooffiles);
									}
								}

		                        $hash_of_file= md5_file($source_file_path);
		                        $res=$mo2f_malware_db_handler->check_hash($hash_of_file);

		                        $datascan = empty($res)?true:(isset($res[0]->scan_data) ? unserialize($res[0]->scan_data):false);
		                        $scanmalware = is_array($datascan)?$datascan['malware']==0:(!empty($datascan) ? $datascan: true);
		                        $repocheck = is_array($datascan)?$datascan['repo']==0:(!empty($datascan) ? $datascan: true);
		                        $extlink = is_array($datascan)?$datascan['ext_link']==0:(!empty($datascan) ? $datascan: true);
		                        $malware_status = $scanmalware? 0 : 1;
								$repo_status = $repocheck? 0 : 1;
								$link_status = $extlink? 0 : 1;
		                        if(!empty($res) && !$extlink && !$repocheck && !$scanmalware ){}
		                        	
		                        else{
		                        	$flag_update=0;
		                        	$file_content=file_get_contents($source_file_path);
		                        	$source_file_path_size = str_replace("\\", "/", $source_file_path);
		                        	if(($scan_config['check_vulnerable'] == 1 || $scan_config['check_sql'] == 1) && !in_array($ext, array('zip','sitx','7z','rar','gz')) && filesize($source_file_path_size) < 1048576 && $malware_server_status && $extns && $scanmalware){
		                        		$malware_status = 1;
		                        		$cfile=curl_file_create($source_file_path, 'test/plain', time().basename($source_file_path));
		                        		$postdata = array('file' => $cfile);
		                        		$content_type = 'multipart/form-data';
		                        		$issues = $this->mo_wpns_malware_scan_request( $host, $content_type,$postdata);
		                        		if ($issues) {
		                        			$scan_malware_count++;
		                        			$scanresult['scan'] = $issues;
		                        			$flag_update=1;
		                        		}
			                        }else{

			                        }

			                        if($scan_config['check_repo'] == 1 && $repocheck && $extns){
										if(!in_array('wp-config.php', $arr) && !in_array($ext, array('zip', 'log', 'htaccess','sitx','7z','rar','gz'))){
											if(($arr[count($arr)-1]== 'index.php' && (count($arr)==1 || in_array($arr[count($arr)-2], array('wp-content', 'plugins', 'themes'))) && !in_array('uploads', $arr)) || !in_array('wp-content', $arr)){
												$repo_status = 1;
					                        	if($value==$base){
					                        		$repo_file_path=$repo_folder_path['base'];
					                        	} elseif ($value == $base.DIRECTORY_SEPARATOR . 'wp-content' . DIRECTORY_SEPARATOR . 'plugins') {
					                        		$repo_file_path=$repo_folder_path['plugins'];
					                        	} elseif ($value == $base.DIRECTORY_SEPARATOR . 'wp-content' . DIRECTORY_SEPARATOR . 'themes') {
					                        		$repo_file_path=$repo_folder_path['themes'];
					                        	}
					                        	$issues = $this->check_with_repo_files($file_content, $repo_file_path.DIRECTORY_SEPARATOR.$iterator->getSubPathName());
			                                   	if(!empty($issues)){
			                                   		$repo_issue_count++;
			                                   		$scanresult['repo']=$issues;
			                                   		$flag_update=1;
			                                    }
				                            }
				                        }
			                        }
			                        if($extns && $extlink){
										if($scan_config['ext_link_check'] == 1){
											$link_status = 1;
											$elresult= $this->check_external_link($file_content);
											if(!empty($elresult)){
												$malicious_link_count++;
												$flag_update=1;
												$scanresult['extl']=$elresult;
											}
										}
									}
									if($flag_update == 0){
										$malware_status = ($scan_config['check_vulnerable'] || $scan_config['check_sql']) && $malware_status ? 1 : 0;
										$repo_status = $scan_config['check_repo'] && $repo_status ? 1 : 0;
										$link_status = $scan_config['ext_link_check'] && $link_status ? 1: 0;
										$scan_data = array('malware'=>$malware_status, 'repo'=>$repo_status, 'ext_link'=>$link_status);
										if(empty($res)){
											$mo2f_malware_db_handler->insert_hash($source_file_path, $hash_of_file, $scan_data);
										}else{
											$mo2f_malware_db_handler->update_hash($source_file_path, $hash_of_file, $scan_data);
										}
									}else{
										$infected_files=get_option('mo_wpns_infected_files');
										$infected_files++;
										if(!empty($res)){
											$mo2f_malware_db_handler->delete_hash($source_file_path);
										}
										update_option('mo_wpns_infected_files', $infected_files);
									}
		                        }
								if(!empty($scanresult))
									$scanresults[$source_file_path]=$scanresult;
							}
						}
					}
				}
				$malware_server_status = $this->mo_wpns_check_malware_server_status($hostname);
				if($malware_server_status){
					$host = 'http://scanner.api.xecurify.com/malwareservice/rest/file/data';
					$postdata = http_build_query(array('fileCount' => $nooffiles, 'maliciousCount' => $scan_malware_count));
					$content_type = 'application/x-www-form-urlencoded';
			        $lastRequest = $this->mo_wpns_malware_scan_request( $host, $content_type,$postdata);
			    }
				update_option('mo_wpns_files_scanned', $nooffiles);
				return array('file_count'=> $nooffiles, 'malware_count'=>$scan_malware_count, 'repo_issues'=>$repo_issue_count, 'malicious_link'=>$malicious_link_count, 'scan'=>$scanresults);
			}else{
				return array('message'=>'CURL not installed on the server.');
			}
		} else {
			return array('message'=>'No folder selected for scanning.');
		}
	}

	function mo_wpns_check_malware_server_status($host){
		$fsock = @fsockopen($host, 80, $errno, $errstr, 5);
        if ( ! $fsock ){
            return FALSE;
        }else{
        	fclose($fsock);
            return TRUE;
        }
	}

	function mo_wpns_malware_scan_request( $host, $content_type,$postdata = array()){
		$response = null;
		$ch=curl_init($host);
		curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, false );
		curl_setopt( $ch, CURLOPT_ENCODING, "" );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_AUTOREFERER, true );
		curl_setopt( $ch, CURLOPT_MAXREDIRS, 10 );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type: '.$content_type) );
		curl_setopt( $ch, CURLOPT_POST, true );
		curl_setopt( $ch, CURLOPT_POSTFIELDS, $postdata);
		$results=curl_exec($ch);
		curl_close($ch);
		if($results==false){
			error_log('Unable to scan file: '.$postdata['file']->name.' with result: '.$result);
		}else{
			$result = json_decode($results, true);
			if(isset($result['status'])){
				if ($result['status'] == 'success') {
					if($result['result']!='OK')
						$response = $result['result'];
				}else if($result['status']=='error'){
					error_log("Exception on server");
				}
			}else if(strpos($results, 'Summary')){
				
			}else{
				error_log("Any other issues on server");
			}
		}
		return $response;
	}

	function check_with_repo_files($file_content, $repo_file_path){
		$issues = array();
		if(file_exists($repo_file_path)){
	        $content=@file_get_contents($repo_file_path);
            $hash_repo = md5($content);
            $hash_file = md5($file_content);
            if ($hash_file != $hash_repo) {
            	$flag=1;
                $issues=array("exist" => "Mismatch in Files");
            }
	    } else {
	    	$issues=array('exist'=>'Unwanted File Found');
	    }
        return $issues;
	}

	function getlines($contents, $href){
		$newissues = 0;
		$lines = preg_split("/((\r?\n)|(\r\n?))/", $contents);
		for($i=0; $i<count($lines); $i++){
			$line =  $lines[$i];
			if (strpos($line, $href) !== false) {
				$newissues = $i+1;
			}
		}
		return $newissues;
	}

	function check_external_link($contents){
		$issues = array();
		$hrefs = preg_match_all('/<a\s+(?:[^"\'>]+|"[^"]*"|\'[^\']*\')*href=("[^"]+"|\'[^\'‌​]+\'|[^<>\s]+)/i', $contents, $matches) ? $matches: array();
		if(isset($hrefs[1])){
			foreach($hrefs[1] as $href){
				if($this->isexternal($href)){
					$line=$this->getlines($contents, $href);
					$issues[] = array("i"=>"eld", "d"=>$href, "l"=>$line);
				}
			}
		}
		return $issues;
	}

	function isexternal($url) {
	  $url = trim($url);
	  $url = trim($url,';');
	  $url = trim($url,'(');
	  $url = trim($url,')');
	  $url = trim($url,"'");
	  $url = trim($url,'"');
	  $components = parse_url($url); 
	  if(isset($components['host'])){
	  	if(preg_match('/(wordpress|google|miniorange|xecurify|facebook|themeisle|adobe|phppot)/i', $components['host']) === 1) {}
	  	else{
			if(!empty($components['host']) && strpos(strtolower($components['host']),strtolower($_SERVER['HTTP_HOST'])) === false){
				return true;
			}
		}
	  }
	  return false;
	}	
	function check_vulnerable_code($contents){
		$issues = array();
		$tokens = token_get_all($contents);
		
		for($i=0; $i< sizeof($tokens); $i++) {
			$token = $tokens[$i];
			if (is_array($token)) {
				if(in_array(token_name($token[0]), array("T_EVAL"))){
					$issue = $this->getFunctionArgumentsOrEnclosedString("eval", $tokens, $i+1, "vlc", false);
					if(!empty($issue))
						$issues[] = $issue;
				} else if(in_array(token_name($token[0]), array("T_STRING"))){
					if(in_array($token[1],array("popen","fsockopen"))){
							$issue = $this->getFunctionArgumentsOrEnclosedString($token[1], $tokens, $i+1, "vlc", true);
							if(!empty($issue))
								$issues[] = $issue;
					} else if(in_array($token[1],array("assert"))){
						$issue = $this->getFunctionArgumentsOrEnclosedString($token[1], $tokens, $i+1, "vlc", false);
						if(!empty($issue))
							$issues[] = $issue;
					} else if(in_array($token[1],array("exec","shell_exec","passthru","system","proc_"))){
						$issue = $this->getFunctionArgumentsOrEnclosedString($token[1], $tokens, $i+1, "shc", false);
						if(!empty($issue))
							$issues[] = $issue;
					}  else if(in_array($token[1],array("mysql_connect","mysqli_connect","mysqli_real_connect","PDO"))){
						$issue = $this->getFunctionArgumentsOrEnclosedString($token[1], $tokens, $i+1, "sqc", false);
						if(!empty($issue))
							$issues[] = $issue;
					}
				}
			}
		}
		return $issues;
	}

	function getFunctionArgumentsOrEnclosedString($issueFunction, $tokens, $start, $issuetype, $checkForExternalLink){
		
		$flag = 1;
		$argument = "";
		$line = "";
		$issue = array();
		for($j=$start; $j< sizeof($tokens); $j++) {
			$innertoken = $tokens[$j];
			if ($flag==1 && is_array($innertoken)) {
				$argument .= $innertoken[1];
				if(empty($line))
					$line = $innertoken[2];
			} else if($innertoken==";"){
				$argument .= ";";
				if($checkForExternalLink){
					if($this->isexternal($argument)){
						$issue = array("l"=>$line, "t"=> $issueFunction, "i"=>$issuetype, "d"=>$argument);
					}
				} else {
					$issue = array("l"=>$line, "t"=> $issueFunction, "i"=>$issuetype, "d"=>$argument);
				}
				break;
			} else if($flag==1){
				$argument .= $innertoken;
			}
		}
		return $issue;
	}

	function remove_dir($repo_path){
		$dir=$repo_path;
		$it = new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS);
		$files = new RecursiveIteratorIterator($it,RecursiveIteratorIterator::CHILD_FIRST);
		foreach($files as $file) {
		    if ($file->isDir()){
		        rmdir($file->getRealPath());
		    } else {
		        unlink($file->getRealPath());
		    }
		}
		rmdir($dir);
	}

	function count_total_files($folder_paths, $base, $scan_config){

		$file_count=0;
		$file_ext = $scan_config['file_extension'];
		$extensions = array();
		if(empty($file_ext)){

		}else{
			if(strpos($file_ext,';') !=false){
				$extensions = explode(";", $file_ext);
			}else{
				array_push($extensions, $file_ext);
			}
		}
		$enable_extns = $scan_config['type_scan'] == "Custom Scan" && !empty($file_ext) ? false : true;
		$folder_skip_array= empty($scan_config['path_skip']) ? array() : explode(";", $scan_config['path_skip']);
		$skip_path_array= array();
		for($i=0; $i<count($folder_skip_array); $i++){
			$pathParts = explode('/', $folder_skip_array[$i]);
			$n= sizeof($pathParts)-1;
			$folder= $pathParts[$n];
			array_push($skip_path_array, $folder);
		}
		foreach ($folder_paths as $value) {
			if (is_dir($value)) {
				foreach ($iterator = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($value, \RecursiveDirectoryIterator::SKIP_DOTS), \RecursiveIteratorIterator::SELF_FIRST) as $item) {
					if ($item->isFile()) {
						$source_file_path = $value . DIRECTORY_SEPARATOR . $iterator->getSubPathName();
						if ($value == $base && ($scan_config['core_scan'] == 1)){
							$arr = explode(DIRECTORY_SEPARATOR, $iterator->getSubPathName());
							if(($arr[count($arr)-1]== 'index.php' && (count($arr)==1 || in_array($arr[count($arr)-2], array('wp-content', 'plugins', 'themes'))) && !in_array('miniorange', $arr)) || (!in_array('plugins', $arr) && !in_array('themes', $arr) && !in_array('miniorange', $arr))){
										
							}else{
								continue;
							}
						}elseif ($value == $base.DIRECTORY_SEPARATOR.'wp-content'.DIRECTORY_SEPARATOR.'plugins' && explode(DIRECTORY_SEPARATOR,$iterator->getSubPathName())[0]=='index.php'){
							continue;
						} elseif ($value == $base.DIRECTORY_SEPARATOR.'wp-content'.DIRECTORY_SEPARATOR.'themes' &&  explode(DIRECTORY_SEPARATOR,$iterator->getSubPathName())[0]=='index.php'){
							continue;
						}
						$flag_skip=0;
						if (!empty($folder_skip_array)) {
							for($q=0; $q<count($skip_path_array); $q++){
								if(strpos($source_file_path, $skip_path_array[$q])){
									$flag_skip=1;
									break;
								}
							}
						}
						if($flag_skip == 1){
							continue;
						}
						$ext = pathinfo($source_file_path, PATHINFO_EXTENSION);
						$extns = $enable_extns ? true : (in_array($ext, $extensions)? true : false);
						if($extns)
							$file_count++;
					}
				}
			}
		}
		update_option('mo_wpns_total_files', $file_count);
	}
}
new Mo_wpns_Scan_Handler;
?>