<?php
class Mo_wpns_scan_malware
{
	function __construct(){
		add_action( 'admin_init'  , array( $this, 'mo_wpns_malware_scanner_functions' ) );

	}

	public function mo_wpns_malware_scanner_functions(){
		add_action('wp_ajax_mo_wpns_malware_redirect', array( $this, 'mo_wpns_malware_redirect' ));
	

	}

	public function mo_wpns_malware_redirect(){
		switch($_POST['call_type'])
		{
			case "submit_malware_settings_form":
				$this->mo_wpns_save_malware_config_form($_POST);
				break;
			case "malware_scan_initiate":
				$this->mo_wpns_start_malware_scan($_POST);
				break;
			case "wpns_enable_tour":
				update_option('skip_tour', 0);
				break;
			case "wpns_disable_tour":
				update_option('skip_tour', 1);
				break;
			case "malware_progress_bar":
				$this->mo_wpns_get_progress();
				break;
			case "malware_scan_last_result":
				$this->mo_wpns_get_scan_result();
				break;
			case "malware_scan_terminate":
				$this->mo_wpns_stop_scan();
				break;

		}
	}

	public function mo_wpns_save_malware_config_form($POSTED){
		$nonce = $POSTED['nonce'];
	   		if ( ! wp_verify_nonce( $nonce, 'mo-wpns-scan-settings' ) ){
	   			wp_send_json('ERROR');
	   			return;
	   		}
		if(! isset($POSTED['scan_plugin']) && ! isset($POSTED['scan_themes']) && ! isset($POSTED['scan_core'])){
			wp_send_json('folder_error');
		}elseif (! isset($POSTED['vulnerable_check']) && ! isset($POSTED['sql_check']) && ! isset($POSTED['rfi_check']) && ! isset($POSTED['ext_link']) && ! isset($POSTED['repo_check'])) {
			wp_send_json('level_error');
		}
		else{
			$mo_wpns_scan_plugins=isset($POSTED['scan_plugin']) ? sanitize_text_field($POSTED['scan_plugin']) : 0;
			$mo_wpns_scan_themes=isset($POSTED['scan_themes']) ? sanitize_text_field($POSTED['scan_themes']) : 0;
			$mo_wpns_scan_wp_files= isset($POSTED['scan_core']) ? sanitize_text_field($POSTED['scan_core']) : 0;
			$mo_wpns_scan_files_extensions= sanitize_text_field($POSTED['file_type']);
			$mo_wpns_check_vulnerable_code=isset($POSTED['vulnerable_check']) ? sanitize_text_field($POSTED['vulnerable_check']) : 0;
			$mo_wpns_check_sql_injection=isset($POSTED['sql_check']) ? sanitize_text_field($POSTED['sql_check']) : 0;
			$mo_wpns_check_external_link=isset($POSTED['ext_link']) ? sanitize_text_field($POSTED['ext_link']) : 0;
			$mo_wpns_scan_files_with_repo=isset($POSTED['repo_check']) ? sanitize_text_field($POSTED['repo_check']) : 0;
			$folders_to_skip= sanitize_text_field($POSTED['skip_path']);
			$folders_to_skip = str_replace('\\\\', '/', $folders_to_skip);
			$str="";

			$mo_wpns_skip_folders="";
			if(!empty($folders_to_skip)){
				$folders_to_skip_array=explode(";",$folders_to_skip);
				for($i=0; $i< count($folders_to_skip_array); $i++){
					if(is_dir($folders_to_skip_array[$i])){
						$str.= $folders_to_skip_array[$i];
						if($i!= count($folders_to_skip_array)-1){
							$str.=";";
						}
					}elseif($folders_to_skip_array[$i] == ''){
						$str.= $folders_to_skip_array[$i];
					}
					else{
						wp_send_json('path_error');
					}
				}
				$mo_wpns_skip_folders=$str;
			}else{
				$mo_wpns_skip_folders=$folders_to_skip;
			}

			$scan_configuration = array(
				'plugin_scan' => $mo_wpns_scan_plugins,
				'theme_scan'  => $mo_wpns_scan_themes,
				'core_scan'	  => $mo_wpns_scan_wp_files,
				'file_extension' => $mo_wpns_scan_files_extensions,
				'check_vulnerable' => $mo_wpns_check_vulnerable_code,
				'check_sql' => $mo_wpns_check_sql_injection,
				'ext_link_check' => $mo_wpns_check_external_link,
				'check_repo' => $mo_wpns_scan_files_with_repo,
				'path_skip' => $mo_wpns_skip_folders,
				'type_scan' => "",
			);

			$encoded_scan_configuration=json_encode($scan_configuration);
			update_site_option("mo_wpns_scan_configuration",$encoded_scan_configuration);
			wp_send_json('save_success');
		}
	}

	public function mo_wpns_start_malware_scan($POSTED){
		$decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
		if(isset($decoded_scan_configuration)){
			$status = $decoded_scan_configuration->scan_progress;
		}else{
			$status=false;
			$scan_mode=false;
		}
		if($status == "IN PROGRESS"){
			wp_send_json('scanning_already');
		}
        global $moWpnsUtility, $mo2f_dirName;

		$mo_wpns_scan_handler = new Mo_wpns_Scan_Handler_Cron();
		$mo2f_malware_db_handler = new MoWpnsDB();

		$current_time= time();
		update_site_option('mo_wpns_last_scan_time', $current_time);
		$plugin_current= get_plugins();
		update_site_option('mo_wpns_last_plugins', $plugin_current);
		$args=array();
		$theme_current= wp_get_themes($args);
		update_site_option('mo_wpns_last_themes', $theme_current);
		update_site_option('malware_notification_option',1);

		update_site_option('mo2f_scan_initialize', 0);
		update_site_option('mo_wpns_hide_malware_popup', 1);

		$mo_wpns_malware_scan_in_progress="IN PROGRESS";
		$mo_wpns_files_scanned=0;
		$mo_wpns_infected_files=0;
		$mo_wpns_warning_files=0;
		$wordpress_download_status=false;

		update_site_option('mo_wpns_infected_files',0);
		update_site_option('mo_wpns_warning_files',0);
		update_site_option('mo2f_files_skipped', 0);
		update_site_option('mo2f_file_size_excess', 0);
		update_site_option('mo2f_download_done', 0);


		$scan_status = array(
							'scan_progress' => $mo_wpns_malware_scan_in_progress,
							'files_scanned' => $mo_wpns_files_scanned,
							'infected_files' => $mo_wpns_infected_files,
							'warning_files' => $mo_wpns_warning_files,
							'total_files' => 0,
							'check_with_repo' => 0,
							'extlink_check' => 0,
							'scan_mode' => "",
							'average_time_each_file' => 0,
							'total_files_processed' => 0,
							'status_download_time' => $wordpress_download_status
		);

		$encoded_scan_status=json_encode($scan_status);
		update_site_option("mo_wpns_scan_status",$encoded_scan_status);


		$mo2f_malware_db_handler->delete_files_parts();

		if(isset($POSTED['scan']) && $POSTED['scan']=='scan_start'){
			$scan_configuration = array();
			switch($POSTED['scantype'])
			{
				case "quick_scan":
					$nonce = $POSTED['nonce'];
			   		if ( ! wp_verify_nonce( $nonce, 'wpns-scan-nonce' ) ){
			   			wp_send_json('ERROR');
			   			return;
			   		}
					$scan_configuration = MoWpnsConstants::$quick_scan_configuration;
					update_site_option('mo_wpns_scan_mode','quick_scan');
					$scan_status = array(
						'scan_progress' => $mo_wpns_malware_scan_in_progress,
						'files_scanned' => $mo_wpns_files_scanned,
						'infected_files' => $mo_wpns_infected_files,
						'warning_files' => $mo_wpns_warning_files,
						'total_files' => 0,
						'check_with_repo' => 0,
						'extlink_check' => 0,
						'average_time_each_file' => 0,
						'total_files_processed' => 0,
						'scan_mode' => "quick_scan",
						'status_download_time' => $wordpress_download_status
					);

					$encoded_scan_status=json_encode($scan_status);
					update_site_option("mo_wpns_scan_status",$encoded_scan_status);
					$mo_wpns_scan_handler->mo2f_scan_all_files($scan_configuration, $current_time); //recheck
					break;
				case "standard_scan":
					$nonce = $POSTED['nonce'];
			   		if ( ! wp_verify_nonce( $nonce, 'wpns-scan-nonce' ) ){
			   			wp_send_json('ERROR');
			   			return;
			   		}
					$scan_configuration = MoWpnsConstants::$standard_scan_configuration;
					update_site_option('mo_wpns_scan_mode','standard_scan');
					$scan_status = array(
						'scan_progress' => $mo_wpns_malware_scan_in_progress,
						'files_scanned' => $mo_wpns_files_scanned,
						'infected_files' => $mo_wpns_infected_files,
						'warning_files' => $mo_wpns_warning_files,
						'total_files' => 0,
						'check_with_repo' => 1,
						'extlink_check' => 1,
						'total_files_processed' => 0,
						'average_time_each_file' => 0,
						'scan_mode' => "standard_scan",
						'status_download_time' => $wordpress_download_status
					);

					$encoded_scan_status=json_encode($scan_status);
					update_site_option("mo_wpns_scan_status",$encoded_scan_status);
					$mo_wpns_scan_handler->mo2f_scan_all_files($scan_configuration, $current_time); //recheck
					break;
				case "custom_scan":
					$nonce = $POSTED['nonce'];
			   		if ( ! wp_verify_nonce( $nonce, 'wpns-scan-nonce' ) ){
			   			wp_send_json('ERROR');
			   			return;
			   		}
					$decode_scan_configuration=json_decode(get_site_option("mo_wpns_scan_configuration"));
					if(is_null($decode_scan_configuration))
					{
						delete_option("mo_wpns_scan_status",$encoded_scan_status);
						wp_send_json("RECONFIGURE");
					}
						
					$scan_configuration = array('plugin_scan' => $decode_scan_configuration->plugin_scan,
					                            'theme_scan'  => $decode_scan_configuration->theme_scan,
					                            'core_scan'	  => $decode_scan_configuration->core_scan,
					                            'file_extension' => $decode_scan_configuration->file_extension,
					                            'check_vulnerable' => $decode_scan_configuration->check_vulnerable,
					                            'check_sql' => $decode_scan_configuration->check_sql,
					                            'ext_link_check' => $decode_scan_configuration->ext_link_check,
					                            'check_repo' => $decode_scan_configuration->check_repo,
					                            'path_skip' => $decode_scan_configuration->path_skip,
					                            'type_scan' => "Custom Scan"
					);


					$scan_status = array(
						'scan_progress' => $mo_wpns_malware_scan_in_progress,
						'files_scanned' => $mo_wpns_files_scanned,
						'infected_files' => $mo_wpns_infected_files,
						'warning_files' => $mo_wpns_warning_files,
						'total_files' => 0,
						'extlink_check' => $decode_scan_configuration->ext_link_check,
						'check_with_repo' => $decode_scan_configuration->check_repo,
						'average_time_each_file' => 0,
						'total_files_processed' => 0,
						'scan_mode' => "custom_scan",
						'status_download_time' => $wordpress_download_status
					);

					$encoded_scan_status=json_encode($scan_status);
					update_site_option("mo_wpns_scan_status",$encoded_scan_status);
					update_site_option('mo_wpns_scan_mode','custom_scan');
					update_site_option('mo2f_custom_scan_config', $scan_configuration);
					$mo_wpns_scan_handler->mo2f_scan_all_files($scan_configuration, $current_time); //recheck
					break;
			}
		}
	}


	public function mo_wpns_get_progress(){

		$decoded_scan_status=json_decode(get_site_option('mo_wpns_scan_status'));
		$status= $decoded_scan_status->scan_progress;
		$files_scanned= $decoded_scan_status->files_scanned;
		$total_files = $decoded_scan_status->total_files;
		$check_repo = $decoded_scan_status->check_with_repo;
		$extlink_check = $decoded_scan_status->extlink_check;
		$scan_mode= $decoded_scan_status->scan_mode;
		$status_download= $decoded_scan_status->status_download_time;
		$averageFileScanTime= $decoded_scan_status->average_time_each_file;
		$total_files_processed= $decoded_scan_status->total_files_processed;
		if($status_download != false && $status == "IN PROGRESS"){
			$time_spent_in_downloading= time()-$status_download;

			if($time_spent_in_downloading > 600){
				$mo2f_malware_db_handler = new MoWpnsDB();
				$reportid= get_site_option('mo2f_report_id');
				$last_report = $mo2f_malware_db_handler->get_report_with_id($reportid);
				if(!empty($last_report)){
					$issue = $last_report[0]->repo_key;
					$repo_key = get_site_option('mo2f_current_repo_key');
					if($repo_key == 'core'){
	    				$issue.= "WordPress Core Files;";
	    			}else{
	    				$issue.= $repo_key.";";
	    			}
		    		$mo2f_malware_db_handler->mo2f_update_repo_issue($reportid, $issue);
				}
				$scan_mode = get_site_option('mo_wpns_scan_mode');
				if ( $scan_mode == 'Quick Scan' ) {
				    $scan_config = MoWpnsConstants::$quick_scan_configuration;
			    } elseif ( $scan_mode == 'Standard Scan' ) {
				    $scan_config = MoWpnsConstants::$standard_scan_configuration;
			    } else {
				    $scan_config = get_site_option( 'mo2f_custom_scan_config' ); 
			    }
			    $uploads_dir = wp_upload_dir();
				$uploads_path= $uploads_dir['basedir'];
			    $repo_file_path = $uploads_path . DIRECTORY_SEPARATOR . "miniorangescan";
			    $scanverification = get_site_option( "mo2f_scanverification" );
				$req_obj = new mo2f_scanner_parts();
				$req_obj->mo2f_make_next_request($scan_config, $reportid, $scanverification, $repo_file_path);
			}
		}
		$repo_scan=0;
		if($scan_mode == "standard_scan" || ($scan_mode == "custom_scan" && $check_repo == 1)){
			$repo_scan=1;
		}
		if($status == "IN PROGRESS"){
			$result=array("status"=>$status, "scanned"=>$files_scanned, "total"=>$total_files, "repo_scan"=> $repo_scan,"extlink_check"=> $extlink_check,"AverageFileTime"=>$averageFileScanTime,"total_files_processed"=>$total_files_processed);
			wp_send_json($result);
		}
		else{
			//stop scan check
			$stop_scan=get_site_option('mo_stop_scan');

			$mo_wpns_db_handler = new MoWpnsDB();
			$total_scan=$mo_wpns_db_handler->count_files();
			$total_malicious=$mo_wpns_db_handler->count_malicious_files();
			$last_id=$mo_wpns_db_handler->get_last_id();
			$send_id=$last_id[0]->max;
			$last_scan=$mo_wpns_db_handler->count_files_last_scan($send_id);
			$malicious_last_scan= get_site_option('mo_wpns_infected_files');
			$warning_last_scan = get_site_option('mo_wpns_warning_files');
			if($total_scan > 999){
				$total_scan=($total_scan/1000);
				$total_scan= round($total_scan,1)."k";
			}
			if($total_malicious > 999){
				$total_malicious=($total_malicious/1000);
				$total_malicious= round($total_malicious,1)."k";
			}
			if($last_scan > 999){
				$last_scan = ($last_scan/1000);
				$last_scan = round($last_scan,1)."k";
			}
			if($stop_scan){
				$status="ABORTED";
				$result = array("status"=>$status, 'total_files'=>$total_scan,"AverageFileTime"=>$averageFileScanTime, 'total_mal'=>$total_malicious, 'scan_files'=>$last_scan, 'mal_files'=>$malicious_last_scan, 'warnings'=>$warning_last_scan,"total_files_processed"=>$total_files_processed);
				wp_send_json($result);
			}
			$result = array("status"=>$status, 'total_files'=>$total_scan, 'total_mal'=>$total_malicious,"AverageFileTime"=>$averageFileScanTime, 'scan_files'=>$total_files, 'mal_files'=>$malicious_last_scan, 'warnings'=>$warning_last_scan,"total_files_processed"=>$total_files_processed);
			wp_send_json($result);
		}
	}

	function mo_wpns_stop_scan(){
		update_site_option('mo_stop_scan','1');
		$mo2f_malware_db_handler = new MoWpnsDB();
		$mo2f_malware_db_handler->delete_files_parts();
		wp_send_json('success');
	}


	

	

	function mo_wpns_get_scan_result(){
		$decoded_scan_configuration=json_decode(get_site_option('mo_wpns_scan_status'));
		$status=$decoded_scan_configuration->scan_progress;
		$mo_wpns_db_handler = new MoWpnsDB();
		$result = $mo_wpns_db_handler->get_report();
		$str1= $_SERVER['REQUEST_URI'];
		$str1= str_replace("admin-ajax.php", "admin.php?page=mo_2fa_malwarescan", $str1);
		$currenturl = remove_query_arg('delete',$str1);
		$currenturl = remove_query_arg('view',$currenturl);
		$currenturl = remove_query_arg('trust',$currenturl);
		$currenturl = remove_query_arg('trustchanged',$currenturl);
		$htmldata = "";
		if(!empty($result)){
			foreach($result as $report){
				if(empty($report->scan_mode)){
					$report->scan_mode="Custom Scan";
				}
				$repo_count = $report->repo_issues >= 0 ? $report->repo_issues : 0;
				$htmldata .= "<tr><td style=text-align:center>".$report->scan_mode."</td>";
				$htmldata .= "<td style=text-align:center>";
				if(!empty($report->scanned_folders)){
					foreach(explode(";",$report->scanned_folders) as $folder){
						if(!empty($folder)){
							$htmldata .= $folder."<br>";
						}
					}
				}
				$htmldata .= "</td><td style=text-align:center>";
				$htmldata .= "<span style=color:green id=scan_files>".$report->scanned_files." files scanned<br></span>";
				$htmldata .= "<span style=color:red id=malicious_files>".$report->malware_count." malware found<br></span>";
				if($report->repo_issues < 0){
					$htmldata .= "<span style=color:orange id=malicious_files>Issues with repository check<br></span>";
				}
				$htmldata .= "<span style=color:orange id=warning_files>".($repo_count+$report->malicious_links)." warnings found</span>";
				$htmldata .= "</td><td style=text-align:center id=start_time>".date("M j, Y, g:i:s a",$report->start_timestamp)."</td>";
				$htmldata .= "<td><a href='".add_query_arg( array('tab' => 'default', 'view' => $report->id), $currenturl )."'>View Details</a> <a href='".add_query_arg( array('tab' => 'default', 'delete' => $report->id), $currenturl )."'>Delete</a></td>";
				$htmldata .= "</tr>";
			
			}
		}else{
			$htmldata .= '<tr class="odd"><td valign="top" colspan="5" class="dataTables_empty">No data available in table</td></tr>';
		}
		wp_send_json($htmldata);
		
	}
}
new Mo_wpns_scan_malware();
?>
