<?php

class WOOCCM_PRO_Order_Email_Controller {


	protected static $_instance;

	public function __construct() {
		add_action( 'woocommerce_email_after_order_table', array( $this, 'add_custom_fields' ), 10 );
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	// Frontend
	// ---------------------------------------------------------------------------

	public function add_custom_fields( $order ) {

		if ( get_option( 'wooccm_email_custom_fields', 'yes' ) === 'yes' ) {

			$order_id = $order->get_id();

			$allowed_order_status = array_values( get_option( 'wooccm_email_custom_fields_status', array_keys( wc_get_order_statuses() ) ) );

			if ( in_array( "wc-{$order->get_status()}", $allowed_order_status ) ) {
				wc_get_template( 'templates/emails/email-custom-fields.php', array( 'order_id' => $order_id ), '', WOOCCM_PRO_PLUGIN_DIR );
			}
		}

		if ( get_option( 'wooccm_email_upload_files', 'no' ) === 'yes' ) {

			$allowed_order_status = array_values( get_option( 'wooccm_email_upload_files_order_status', array_keys( wc_get_order_statuses() ) ) );

			if ( in_array( "wc-{$order->get_status()}", $allowed_order_status ) ) {

				$attachments = get_posts(
					array(
						'fields'      => 'ids',
						'post_type'   => 'attachment',
						'numberposts' => -1,
						'post_status' => null,
						'post_parent' => $order->get_id(),
					)
				);

				wc_get_template(
					'templates/emails/email-upload-files.php',
					array(
						'order'       => $order,
						'attachments' => $attachments,
					),
					'',
					WOOCCM_PRO_PLUGIN_DIR
				);
			}
		}
	}
}

WOOCCM_PRO_Order_Email_Controller::instance();
