<?php

class WOOCCM_PRO_Fields_Validate_Regex {

	protected static $_instance;

	function is_valid_regex( $regex ) {
		return @preg_match( $regex, '' ) !== false;
	}

	function is_valid_string_format( $string, $regex ) {
		if ( preg_match( $regex, $string ) ) {
			return true;
		}
		return false;
	}

	function validate_field( $field, $fields, &$errors ) {
		if ( isset( $fields[ $field['key'] ] ) && ! empty( $field['validate_regex'] ) ) {
			$value = $fields[ $field['key'] ];
			if ( ! $this->is_valid_regex( $field['validate_regex'] ) ) {
				$errors->add( 'validation', sprintf( esc_html__( '%s regex is invalid.', 'woocommerce-checkout-manager-pro' ), $field['validate_regex'] ) );
			} elseif ( ! $this->is_valid_string_format( $value, $field['validate_regex'] ) ) {
				$errors->add( 'validation', sprintf( '<b>%s</b> %s', $field['label'], esc_html__( 'has invalid format.', 'woocommerce-checkout-manager-pro' ) ) );
			}
		}
	}

	public function __construct() {
		add_action(
			'woocommerce_after_checkout_validation',
			function ( $fields, $errors ) {
				$billing_fields    = WOOCCM()->billing->get_fields();
				$shipping_fields   = WOOCCM()->shipping->get_fields();
				$additional_fields = WOOCCM()->additional->get_fields();

				foreach ( $billing_fields as $field_id => $field ) {
					$this->validate_field( $field, $fields, $errors );
				}

				foreach ( $shipping_fields as $field_id => $field ) {
					$this->validate_field( $field, $fields, $errors );
				}

				foreach ( $additional_fields as $field_id => $field ) {
					$this->validate_field( $field, $fields, $errors );
				}
			},
			10,
			2
		);
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

}

WOOCCM_PRO_Fields_Validate_Regex::instance();
