<?php
/**
 * Shoptimizer child theme functions
 *
 * @package shoptimizer
 */

/**
 * Loads parent and child theme scripts.
 */
function shoptimizer_child_enqueue_scripts() {
	$parent_style    = 'shoptimizer-style';
	$parent_base_dir = 'shoptimizer';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css', array(), wp_get_theme( $parent_base_dir ) ? wp_get_theme( $parent_base_dir )->get( 'Version' ) : '' );

	if ( is_rtl() ) {
		wp_enqueue_style( 'shoptimizer-rtl', get_template_directory_uri() . '/rtl.css', array(), wp_get_theme( $parent_base_dir ) ? wp_get_theme( $parent_base_dir )->get( 'Version' ) : '' );
	}

	wp_enqueue_style( 'shoptimizer-child-style', get_stylesheet_directory_uri() . '/style.css', array( $parent_style ), wp_get_theme()->get( 'Version' ) );
}

add_filter( 'rank_math/snippet/rich_snippet_product_entity', function( $entity ) {
   
	$entity['gtin13'] = str_replace('-', '',$entity['sku']);
	$entity['offers']['priceValidUntil'] = '2020-12-31';
	return $entity;
});


add_filter( 'rank_math/snippet/rich_snippet_product_entity', function( $entity ) {
    $entity['brand'] = 'GurgaonBakers';
    return $entity;
});

add_action( 'wp_enqueue_scripts', 'shoptimizer_child_enqueue_scripts' );

add_filter( 'woocommerce_product_single_add_to_cart_text', 'woocommerce_custom_single_add_to_cart_text' ); 
function woocommerce_custom_single_add_to_cart_text() {
    return __( 'Buy Now', 'woocommerce' ); 
}

add_filter( 'woocommerce_product_add_to_cart_text' , 'custom_woocommerce_product_add_to_cart_text' );
function custom_woocommerce_product_add_to_cart_text() {
    global $product;    
    $product_type = $product->get_type();
    switch ( $product_type ) {
		case 'variable':
            return __( 'Buy Now', 'woocommerce' );
		case 'simple':
            return __( 'Buy Now', 'woocommerce' );	
        break;
	}
} 

/*function my_custom_add_to_cart_redirect( $url ) {  
 // for custom/home page in our case.
 $url = home_url()."/cakes/add-ons/"; 
 return $url;
}
add_filter( 'woocommerce_add_to_cart_redirect', 'my_custom_add_to_cart_redirect' ); */

function my_custom_add_to_cart_redirect1( $url ) {

	if ( ! isset( $_REQUEST['add-to-cart'] ) || ! is_numeric( $_REQUEST['add-to-cart'] ) ) {
		return $url;
	}

	$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_REQUEST['add-to-cart'] ) );

	// Only redirect products that have the 't-shirts' category
	if ( has_term( 'add-ons', 'product_cat', $product_id ) ) {
		$url = wc_get_cart_url();
	}else{
		$url = home_url()."/cakes/add-ons/"; 
	}

	return $url;

}
add_filter( 'woocommerce_add_to_cart_redirect', 'my_custom_add_to_cart_redirect1' );

add_filter ( 'wc_add_to_cart_message', 'wc_add_to_cart_message_filter', 10, 2 );
function wc_add_to_cart_message_filter($message, $product_id = null) {
    $titles[] = get_the_title( $product_id );

    $titles = array_filter( $titles );
    $added_text = sprintf( 'product has been added to your cart.' );

    $message = sprintf( '%s <a href="%s" class="button addon-chkout-btn" style="">%s</a>&nbsp;<a href="%s" class="button update-disable" style="margin-right: 10px;">%s</a>',
                    esc_html( $added_text ),
                    esc_url( wc_get_page_permalink( 'checkout' ) ),
                    esc_html__( 'PROCEED TO CHECKOUT', 'woocommerce' ),
                    esc_url( wc_get_page_permalink( 'cart' ) ),
                    esc_html__( 'VIEW CART', 'woocommerce' ));

    return $message;
}

add_filter( 'woocommerce_get_related_product_cat_terms', 'remove_related_product_categories', 10, 2 );
function remove_related_product_categories( $terms_ids, $product_id  ){
    return array();
}
/*
add_action('wp_footer',function(){
	
		echo '<script>

		//for existing content
		jQuery(".woocommerce-LoopProduct-link").attr("target","_blank");

		//for content part which comes from AJAX
		jQuery( document ).ajaxComplete(function() {
			jQuery(".woocommerce-LoopProduct-link").attr("target","_blank");
		});
		</script>';
	
}); */
/*
function move_variation_price() {
	remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation', 10 );
	add_action( 'woocommerce_before_variations_form', 'woocommerce_single_variation', 10 );
}
add_action( 'woocommerce_before_add_to_cart_form', 'move_variation_price' ); */

add_action( 'woocommerce_before_single_product', 'move_variations_single_price', 1 );
function move_variations_single_price(){
  global $product, $post;
  if ( $product->is_type( 'variable' ) ) {
    add_action( 'woocommerce_single_product_summary', 'replace_variation_single_price', 10 );
  }
}

function replace_variation_single_price() {
  ?>
    <style>
      .woocommerce-variation-price {
        display: none;
      }
		.woocommerce-variation-description{
			display: none;
		}	
    </style>
    <script>
      jQuery(document).ready(function($) {
        var priceselector = '.product p.price';
        var originalprice = $(priceselector).html();

        $( document ).on('show_variation', function() {
          $(priceselector).html($('.single_variation .woocommerce-variation-price').html());
        });
        $( document ).on('hide_variation', function() {
          $(priceselector).html(originalprice);
        });
      });
    </script>
  <?php
}

add_filter('woocommerce_variable_price_html', 'custom_price_text', 10, 2);

function custom_price_text( $price, $product ) {
	$tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
	if ( !empty( $tax_rates ) ) {
            $tax_rate = reset($tax_rates);
			$price_incl_tax =  $product->get_price() + ( $product->get_price() * $tax_rate['rate'] / 100 );
	}
         $price = '';
         $price .= '<span class="from">' . _x('', 'min_price', 'woocommerce') . ' </span>';        
         $price .= wc_price($price_incl_tax);

         return $price;
}

add_action( 'template_redirect', 'null_removed_cart_item_message'  );
function null_removed_cart_item_message() {
    // Only on cart page
    if( ! is_cart() && !is_product_category() && !is_product() && !is_checkout()) return;
    // Get the WC notices array stored in WC_Session
    $wc_notices = (array) WC()->session->get( 'wc_notices' );
    $found      = false; // Initializing
    // Check that we have at least one "success" notice type
    if( isset($wc_notices['success']) && sizeof($wc_notices['success']) ) {
        // Loop through "success" notices type
        foreach( $wc_notices['success'] as $key => $wc_notice ) {
            // Remove notices that contain the word "removed" from the array
            if ( strpos($wc_notice, "has been added") !== false ) {
                unset($wc_notices['success']);
                $found = true;
            }
        }
    }
    if( $found ) {
        // Set back the notices array to WC_Session
        WC()->session->set( 'wc_notices', $wc_notices );
    }
}

add_filter( 'woocommerce_catalog_orderby', 'misha_remove_default_sorting_options' );
 
function misha_remove_default_sorting_options( $options ){
 
	unset( $options[ 'popularity' ] );
	//unset( $options[ 'menu_order' ] );
	unset( $options[ 'rating' ] );
	unset( $options[ 'date' ] );
	//unset( $options[ 'price' ] );
	//unset( $options[ 'price-desc' ] );
 
	return $options;
 
}


add_action( 'woocommerce_thankyou', 'ds_checkout_analytics' );

function disable_shipping_calc_on_cart( $show_shipping ) {
    if( is_cart() ) {
        return false;
    }
    return $show_shipping;
}
add_filter( 'woocommerce_cart_ready_to_calc_shipping', 'disable_shipping_calc_on_cart', 99 );

add_filter( 'action_scheduler_retention_period', function() { return DAY_IN_SECONDS * 5; } );


// deactivate new block editor
function phi_theme_support() {
    remove_theme_support( 'widgets-block-editor' );
}
add_action( 'after_setup_theme', 'phi_theme_support' );

add_filter( 'woocommerce_product_tabs', 'woo_new_product_tab' );
function woo_new_product_tab( $tabs ) {
		
	$tabs['test_tab'] = array(
		'title' 	=> __( 'Testimonials', 'woocommerce' ),
		'priority' 	=> 50,
		'callback' 	=> 'woo_new_product_tab_content'
	);
	return $tabs;
}

function woo_new_product_tab_content() {

	echo '<div style="display: flex;">
	<div class="elementor-image" style="min-width: 20%;padding: 10px;"></div>
	<div class="elementor-image" style="min-width: 20%;padding: 10px;"> 
		<a href="https://g.page/GurgaonBakers/review?rc" target="_blank" rel="nofollow"> 
			<img width="233" height="119" src="https://gurgaonbakers.com/wp-content/uploads/2021/10/google-testimonials.jpg" class="attachment-large size-large" alt="Google Reviews" loading="lazy" srcset="https://gurgaonbakers.com/wp-content/uploads/2021/10/google-testimonials.jpg 233w, https://gurgaonbakers.com/wp-content/uploads/2021/10/google-testimonials.jpg 150w" sizes="(max-width: 360px) 147px, (max-width: 233px) 100vw, 233px" title="Reviews" style="border-style: solid; border-width: 1px; border-color: #ee2b2b; box-shadow: 6px 6px 10px 0px rgb(0 0 0 / 50%);"> 
		</a>
	</div>
	<div class="elementor-image" style="min-width: 20%;padding: 10px;"> 
		<a href="https://www.facebook.com/gurgaonbakers/reviews/" target="_blank" rel="nofollow noopener"> 
			<img width="233" height="119" src="https://gurgaonbakers.com/wp-content/uploads/2021/10/facebook-testimonials.jpg" class="attachment-large size-large" alt="Facebook Reviews" loading="lazy" srcset="https://gurgaonbakers.com/wp-content/uploads/2021/10/facebook-testimonials.jpg 233w, https://gurgaonbakers.com/wp-content/uploads/2021/10/facebook-testimonials.jpg 150w" sizes="(max-width: 360px) 147px, (max-width: 233px) 100vw, 233px" title="Reviews" style="border-style: solid; border-width: 1px; border-color: #ee2b2b;box-shadow: 6px 6px 10px 0px rgb(0 0 0 / 50%);"> 
		</a>
	</div>
	<div class="elementor-image" style="min-width: 20%;padding: 10px;"> 
		<a href="https://gurgaonbakers.com/reviews/" target="_blank"> 
			<img width="233" height="119" src="https://gurgaonbakers.com/wp-content/uploads/2021/10/all-reviews.jpg" class="attachment-large size-large" alt="All Reviews" loading="lazy" srcset="https://gurgaonbakers.com/wp-content/uploads/2021/10/all-reviews.jpg 233w, https://gurgaonbakers.com/wp-content/uploads/2021/10/all-reviews.jpg 150w" sizes="(max-width: 360px) 147px, (max-width: 233px) 100vw, 233px" title="Reviews" style="border-style: solid; border-width: 1px; border-color: #ee2b2b;box-shadow: 6px 6px 10px 0px rgb(0 0 0 / 50%);"> 
		</a>
	</div>
	<div class="elementor-image" style="min-width: 20%;padding: 10px;"></div>
</div>';
	
}

add_filter( 'woocommerce_countries_tax_or_vat', function () {
  return __( 'Taxes', 'woocommerce' );
});

add_filter( 'woocommerce_countries_inc_tax_or_vat', function () {
  return __( ' ', 'woocommerce' );
});

add_filter( 'woocommerce_get_formatted_order_total', 'change_emails_formatted_order_total', 10, 2 );
function change_emails_formatted_order_total( $formatted_total, $order ) {
    // Remove from order total the formatted taxes displayed on emails notifications only
    return wc_price( $order->get_total(), array( 'currency' => $order->get_currency() ) ) . ' ' . __("(Inclusive of GST)", "woocommerce");
}



add_action( 'woocommerce_thankyou', 'adding_customers_details_to_thankyou', 10, 1 );
function adding_customers_details_to_thankyou( $order_id ) {
    // Only for non logged in users
    if ( ! $order_id ) return;

    $order = wc_get_order($order_id); // Get an instance of the WC_Order object

    wc_get_template( 'order/order-details-customer.php', array('order' => $order ));
}

function wc_cancelled_order_add_customer_email( $recipient, $order ){
     return $recipient . ',' . $order->billing_email;
 }
 add_filter( 'woocommerce_email_recipient_cancelled_order', 'wc_cancelled_order_add_customer_email', 10, 2 );


add_filter('use_block_editor_for_post', '__return_false');

add_filter( 'woocommerce_loop_add_to_cart_link', 'add_to_cart_dofollow', 10, 2 );
function add_to_cart_dofollow($html, $product){
	$html = sprintf( '<a rel="" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s">%s</a>',
		esc_url( $product->add_to_cart_url() ),
		esc_attr( isset( $quantity ) ? $quantity : 1 ),
		esc_attr( $product->get_id() ),
		esc_attr( $product->get_sku() ),
		esc_attr( isset( $class ) ? $class : 'button' ),
		esc_html( $product->add_to_cart_text() )
	);
	return $html;
}

add_action('woocommerce_before_calculate_totals', 'gb_modify_shipping_for_low_value_orders', 20);

function gb_modify_shipping_for_low_value_orders($cart) {
    if (is_admin() && !defined('DOING_AJAX')) {
        return;
    }
    
    // Only run once
    if (did_action('woocommerce_before_calculate_totals') > 1) {
        return;
    }
    
    // Get cart subtotal
    $subtotal = $cart->subtotal;
    
    // Flag for orders under 1500
    if ($subtotal < 2000 ) {
        WC()->session->set('gb_low_value_order', true);
    } else {
        WC()->session->set('gb_low_value_order', false);
    }
}

/**
 * Always add an extra 150 to shipping if cart subtotal <= 1500
 */
function gb_add_conditional_shipping_fee( $cart ) {
    // Only run on the front-end (not in admin unless AJAX)
    if ( is_admin() && ! defined( 'DOING_AJAX' ) ) {
        return;
    }
    if ( ! WC()->cart || WC()->cart->is_empty() ) {
        return;
    }
	
    $subtotal = $cart->get_subtotal() + $cart->get_subtotal_tax();

    // If subtotal <= 1500, add a fee of 150 (which effectively increases shipping)
    if ( $subtotal < 2000 ) {
        $fee_label  = __( 'Small Order Handling Fee', 'text-domain' );
        $fee_amount = 150;
        
        // Third parameter 'false' = non-taxable fee, set to true if you need it taxable
        $cart->add_fee( $fee_label, $fee_amount, false );
    }
}
add_action( 'woocommerce_cart_calculate_fees', 'gb_add_conditional_shipping_fee', 20 );

/**
 * Display a custom message after the order total on the checkout page
 * if the cart subtotal is less than 1500.
 */
function gb_display_promo_message_after_total() {
    // Ensure cart is available
    if ( ! WC()->cart ) {
        return;
    }

    $subtotal = WC()->cart->get_subtotal();

    // Only show if subtotal is less than 2000
    if ( $subtotal < 2000 ) {
        echo '<tr class="order-more-discount">
                <th colspan="2" style="text-align:left; font-weight: normal; border-right: 1px solid #e2e2e2; border-radius:0px 0px 8px 8px;">
                    ' . __( 'Orders below ₹2000 include a ₹150 handling fee. Add more items to your cart and enjoy free handling!', 'text-domain' ) . '
                </th>
              </tr>';
    }
}
add_action( 'woocommerce_review_order_after_order_total', 'gb_display_promo_message_after_total' );








