<?php

class WOOCCM_PRO_Notices {

	protected static $_instance;
	var $free = 'woocommerce-checkout-manager';

	public function __construct() {
		add_action( 'admin_notices', array( $this, 'add_admin_notices' ) );
		add_filter( 'plugin_action_links_' . plugin_basename( WOOCCM_PRO_PLUGIN_FILE ), array( $this, 'add_action_links' ) );
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	function add_action_links( $links ) {
		$links[] = '<a target="_blank" href="' . WOOCCM_PRO_SUPPORT_URL . '">' . esc_html__( 'Support', 'woocommerce-checkout-manager-pro' ) . '</a>';
		$links[] = '<a target="_blank" href="' . WOOCCM_PRO_LICENSES_URL . '">' . esc_html__( 'License', 'woocommerce-checkout-manager-pro' ) . '</a>';

		return $links;
	}

	function add_admin_notices() {

		global $wooccm_license_client;

		$screen = get_current_screen();

		if ( isset( $screen->parent_file ) && 'plugins.php' === $screen->parent_file && 'update' === $screen->id ) {
			return;
		}

		$plugin = "{$this->free}/{$this->free}.php";

		if ( is_plugin_active( $plugin ) && isset( $wooccm_license_client ) ) {

			$activation = $wooccm_license_client->activation->get();

			$license_menu_url = $wooccm_license_client->plugin->get_menu_license_url();

			if ( empty( $activation['license_key'] ) ) {
				?>
				<div class="notice notice-error" data-notice_id="quadmenu-user-rating">
					<div class="notice-container" style="padding-top: 10px; padding-bottom: 10px; display: flex; justify-content: left; align-items: center;">
						<div class="notice-content" style="margin-left: 15px;">
							<p>
								<b><?php printf( esc_html__( 'Please activate your %s license key.', 'woocommerce-checkout-manager-pro' ), WOOCCM_PRO_PLUGIN_NAME ); ?></b>
								<br/>
								<?php esc_html_e( 'Please complete the license activation process to receive automatic updates and enable all premium features.', 'woocommerce-checkout-manager-pro' ); ?>
							</p>
							<a href="<?php echo esc_url( $license_menu_url ); ?>" class="button-primary">
								<?php esc_html_e( 'Activate', 'woocommerce-checkout-manager-pro' ); ?>
							</a>
							<a href="<?php echo esc_url( WOOCCM_PRO_LICENSES_URL ); ?>" class="button-secondary" target="_blank">
								<?php esc_html_e( 'Get license key', 'woocommerce-checkout-manager-pro' ); ?>
							</a>
							<a href="<?php echo esc_url( WOOCCM_PRO_SUPPORT_URL ); ?>"target="_blank">
								<?php esc_html_e( 'Get support', 'woocommerce-checkout-manager-pro' ); ?>
							</a>
						</div>
					</div>
				</div>
				<?php
			}
			return;
		}

		if ( $this->is_installed( $plugin ) ) {

			if ( ! current_user_can( 'activate_plugins' ) ) {
				return;
			}
			?>
			<div class="error">
				<p>
				<a href="<?php echo wp_nonce_url( 'plugins.php?action=activate&amp;plugin=' . $plugin . '&amp;plugin_status=all&amp;paged=1', 'activate-plugin_' . $plugin ); ?>" class='button button-secondary'><?php printf( esc_html__( 'Activate %s', 'woocommerce-checkout-manager-pro' ), WOOCCM_FREE_PLUGIN_NAME ); ?></a>
					<?php printf( esc_html__( '%1$s not working because you need to activate the %2$s plugin.', 'woocommerce-checkout-manager-pro' ), WOOCCM_PRO_PLUGIN_NAME, WOOCCM_FREE_PLUGIN_NAME ); ?>
				</p>
			</div>
			<?php
		} else {
			if ( ! current_user_can( 'install_plugins' ) ) {
				return;
			}
			?>
			<div class="error">
				<p>
				<a href="<?php echo wp_nonce_url( self_admin_url( "update.php?action=install-plugin&plugin={$this->free}" ), "install-plugin_{$this->free}" ); ?>" class='button button-secondary'><?php printf( esc_html__( 'Install %s', 'woocommerce-checkout-manager-pro' ), WOOCCM_FREE_PLUGIN_NAME ); ?></a>
					<?php printf( esc_html__( '%1$s not working because you need to install the %2$s plugin.', 'woocommerce-checkout-manager-pro' ), WOOCCM_PRO_PLUGIN_NAME, WOOCCM_FREE_PLUGIN_NAME ); ?>
				</p>
			</div>
			<?php
		}
	}

	function is_installed( $path ) {
		$installed_plugins = get_plugins();

		return isset( $installed_plugins[ $path ] );
	}
}

WOOCCM_PRO_Notices::instance();
