<?php

final class WOOCCM_PRO {


	protected static $_instance;

	public function __construct() {
		add_action( 'admin_head', array( $this, 'css' ) );
		add_action( 'init', array( $this, 'compatibility' ) );
		add_action( 'woocommerce_init', array( $this, 'includes' ), 15 );
		add_filter( 'wooccm_fields_disabled_types', '__return_empty_array' );

		load_plugin_textdomain( 'woocommerce-checkout-manager-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function compatibility() {
		include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/compatibility/class-wooccm-fields-invoices.php';
		include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/compatibility/class-wooccm-fields-subscriptions.php';
	}

	public function includes() {
		include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/backend/class-wooccm-notices.php';

		if ( class_exists( 'WOOCCM' ) ) {
			include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/backend/class-wooccm-license.php';
			include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/backend/class-wooccm-order.php';
			include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/backend/class-wooccm-export.php';
			include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-email.php';

			if ( ! is_admin() ) {
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-myaccount.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-price.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-display.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-select2.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-timepicker.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-datepicker.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-filters.php';
				include_once WOOCCM_PRO_PLUGIN_DIR . 'includes/view/frontend/class-wooccm-fields-validate-regex.php';
			}

			if ( class_exists( 'WOOCCM_Checkout_Premium_Controller' ) ) {
				$premium = WOOCCM_Checkout_Premium_Controller::instance();
				remove_filter( 'wooccm_sections_header', array( $premium, 'add_menu' ) );
				remove_filter( 'wooccm_sections_header', array( $premium, 'add_header' ) );
			}
		}
	}

	public function css() {         ?>
	<style>
	  .wooccm-premium {
		opacity: 1;
		pointer-events: all;
	  }

	  .wooccm-premium .description.hidden {
		display: inline-block;
	  }

	  .wooccm-premium .description.premium {
		display: none;
	  }
	</style>
		<?php

	}

	public function register_scripts() {
		// UI
		// ---------------------------------------------------------------------
		wp_register_style( 'jquery-ui-style', WC()->plugin_url() . '/assets/css/jquery-ui/jquery-ui.min.css', array(), WC_VERSION );

		// Timepicker
		// ---------------------------------------------------------------------
		wp_register_style( 'jquery-ui-timepicker', plugins_url( 'assets/frontend/timepicker/jquery.ui.timepicker.css', WOOCCM_PRO_PLUGIN_FILE ), array( 'jquery-ui-style' ), WOOCCM_PRO_PLUGIN_VERSION );
		wp_register_script( 'jquery-ui-timepicker', plugins_url( 'assets/frontend/timepicker/jquery.ui.timepicker.js', WOOCCM_PRO_PLUGIN_FILE ), array( 'jquery' ), WOOCCM_PRO_PLUGIN_VERSION, true );
	}
}

WOOCCM_PRO::instance();
